module i32;

import wasm=foundation.wasm;
@safe:
int add (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.add
    return (param_0 + param_1);
}

int sub (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.sub
    return (param_0 - param_1);
}

int mul (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.mul
    return (param_0 * param_1);
}

int div_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.div_s
    return wasm.div(param_0, param_1);
}

int div_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.div_u
    return wasm.div(uint(param_0), uint(param_1));
}

int rem_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.rem_s
    return wasm.rem(param_0, param_1);
}

int rem_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.rem_u
    return wasm.rem(uint(param_0), uint(param_1));
}

int and (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.and
    return (param_0 & param_1);
}

int or (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.or
    return (param_0 | param_1);
}

int xor (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.xor
    return (param_0 ^ param_1);
}

int shl (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.shl
    return (param_0 << param_1);
}

int shr_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.shr_s
    return (param_0 >> param_1);
}

int shr_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.shr_u
    return (param_0 >>> param_1);
}

int clz (int param_0) {
    // local.get 0
    // i32.clz
    return wasm.clz(param_0);
}

int ctz (int param_0) {
    // local.get 0
    // i32.ctz
    return wasm.ctz(param_0);
}

int popcnt (int param_0) {
    // local.get 0
    // i32.popcnt
    return wasm.popcnt(param_0);
}

int eq (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.eq
    return (param_0 == param_1);
}

int ne (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.ne
    return (param_0 != param_1);
}

int lt_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.lt_s
    return (param_0 < param_1);
}

int lt_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.lt_u
    return (uint(param_0) < uint(param_1));
}

int le_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.le_s
    return (param_0 <= param_1);
}

int le_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.le_u
    return (uint(param_0) <= uint(param_1));
}

int gt_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.gt_s
    return (param_0 > param_1);
}

int gt_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.gt_u
    return (uint(param_0) > uint(param_1));
}

int ge_s (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.ge_s
    return (param_0 >= param_1);
}

int ge_u (int param_0, int param_1) {
    // local.get 0
    // local.get 1
    // i32.ge_u
    return (uint(param_0) >= uint(param_1));
}

@safe
unittest { // assert
    { // assert_return
        // expr   07 00 41 01 41 01 10 00
        // result 03 00 41 02
        // i32.const (1)
        // i32.const (1)
        // call 0
        const result_0=add((1),(1));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 00
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 0
        const result_0=add((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 00
        // result 03 00 41 7E
        // i32.const (-1)
        // i32.const (-1)
        // call 0
        const result_0=add((-1),(-1));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 00
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 0
        const result_0=add((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 01 10 00
        // result 07 00 41 80 80 80 80 78
        // i32.const (2147483647)
        // i32.const (1)
        // call 0
        const result_0=add((2147483647),(1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 00
        // result 07 00 41 FF FF FF FF 07
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 0
        const result_0=add((-2147483648),(-1));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 00
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 0
        const result_0=add((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 03 41 01 10 00
        // result 07 00 41 80 80 80 80 04
        // i32.const (1073741823)
        // i32.const (1)
        // call 0
        const result_0=add((1073741823),(1));
        // i32.const (1073741824)
        assert((1073741824) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 01
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 1
        const result_0=sub((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 01
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 1
        const result_0=sub((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 01
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 1
        const result_0=sub((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 7F 10 01
        // result 07 00 41 80 80 80 80 78
        // i32.const (2147483647)
        // i32.const (-1)
        // call 1
        const result_0=sub((2147483647),(-1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 01 10 01
        // result 07 00 41 FF FF FF FF 07
        // i32.const (-2147483648)
        // i32.const (1)
        // call 1
        const result_0=sub((-2147483648),(1));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 01
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 1
        const result_0=sub((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 03 41 7F 10 01
        // result 07 00 41 80 80 80 80 04
        // i32.const (1073741823)
        // i32.const (-1)
        // call 1
        const result_0=sub((1073741823),(-1));
        // i32.const (1073741824)
        assert((1073741824) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 02
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 2
        const result_0=mul((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 02
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 2
        const result_0=mul((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 02
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 2
        const result_0=mul((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 80 80 80 80 01 41 80 20 10 02
        // result 03 00 41 00
        // i32.const (268435456)
        // i32.const (4096)
        // call 2
        const result_0=mul((268435456),(4096));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 02
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 2
        const result_0=mul((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 02
        // result 07 00 41 80 80 80 80 78
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 2
        const result_0=mul((-2147483648),(-1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 7F 10 02
        // result 07 00 41 81 80 80 80 78
        // i32.const (2147483647)
        // i32.const (-1)
        // call 2
        const result_0=mul((2147483647),(-1));
        // i32.const (-2147483647)
        assert((-2147483647) == result_0);
    }
    { // assert_return
        // expr   0E 00 41 E7 8A 8D 09 41 90 E4 D0 B2 07 10 02
        // result 07 00 41 F0 E8 B9 AC 03
        // i32.const (19088743)
        // i32.const (1985229328)
        // call 2
        const result_0=mul((19088743),(1985229328));
        // i32.const (898528368)
        assert((898528368) == result_0);
    }
    { // assert_trap
        // expr   07 00 41 01 41 00 10 03
        // result 
        wasm.assert_trap((() {
                // i32.const (1)
                // i32.const (0)
                // call 3
                const result_0=div_s((1),(0));
                return result_0;
            }
        )());
    }
    { // assert_trap
        // expr   07 00 41 00 41 00 10 03
        // result 
        wasm.assert_trap((() {
                // i32.const (0)
                // i32.const (0)
                // call 3
                const result_0=div_s((0),(0));
                return result_0;
            }
        )());
    }
    { // assert_trap
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 03
        // result 
        wasm.assert_trap((() {
                // i32.const (-2147483648)
                // i32.const (-1)
                // call 3
                const result_0=div_s((-2147483648),(-1));
                return result_0;
            }
        )());
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 03
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 3
        const result_0=div_s((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 03
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 3
        const result_0=div_s((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 03
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 3
        const result_0=div_s((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 02 10 03
        // result 07 00 41 80 80 80 80 7C
        // i32.const (-2147483648)
        // i32.const (2)
        // call 3
        const result_0=div_s((-2147483648),(2));
        // i32.const (-1073741824)
        assert((-1073741824) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 81 80 80 80 78 41 E8 07 10 03
        // result 06 00 41 E5 F6 FC 7E
        // i32.const (-2147483647)
        // i32.const (1000)
        // call 3
        const result_0=div_s((-2147483647),(1000));
        // i32.const (-2147483)
        assert((-2147483) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 02 10 03
        // result 03 00 41 02
        // i32.const (5)
        // i32.const (2)
        // call 3
        const result_0=div_s((5),(2));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 02 10 03
        // result 03 00 41 7E
        // i32.const (-5)
        // i32.const (2)
        // call 3
        const result_0=div_s((-5),(2));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 7E 10 03
        // result 03 00 41 7E
        // i32.const (5)
        // i32.const (-2)
        // call 3
        const result_0=div_s((5),(-2));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 7E 10 03
        // result 03 00 41 02
        // i32.const (-5)
        // i32.const (-2)
        // call 3
        const result_0=div_s((-5),(-2));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 03 10 03
        // result 03 00 41 02
        // i32.const (7)
        // i32.const (3)
        // call 3
        const result_0=div_s((7),(3));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 79 41 03 10 03
        // result 03 00 41 7E
        // i32.const (-7)
        // i32.const (3)
        // call 3
        const result_0=div_s((-7),(3));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 7D 10 03
        // result 03 00 41 7E
        // i32.const (7)
        // i32.const (-3)
        // call 3
        const result_0=div_s((7),(-3));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 79 41 7D 10 03
        // result 03 00 41 02
        // i32.const (-7)
        // i32.const (-3)
        // call 3
        const result_0=div_s((-7),(-3));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 0B 41 05 10 03
        // result 03 00 41 02
        // i32.const (11)
        // i32.const (5)
        // call 3
        const result_0=div_s((11),(5));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 11 41 07 10 03
        // result 03 00 41 02
        // i32.const (17)
        // i32.const (7)
        // call 3
        const result_0=div_s((17),(7));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_trap
        // expr   07 00 41 01 41 00 10 04
        // result 
        wasm.assert_trap((() {
                // i32.const (1)
                // i32.const (0)
                // call 4
                const result_0=div_u((1),(0));
                return result_0;
            }
        )());
    }
    { // assert_trap
        // expr   07 00 41 00 41 00 10 04
        // result 
        wasm.assert_trap((() {
                // i32.const (0)
                // i32.const (0)
                // call 4
                const result_0=div_u((0),(0));
                return result_0;
            }
        )());
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 04
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 4
        const result_0=div_u((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 04
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 4
        const result_0=div_u((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 04
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 4
        const result_0=div_u((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 04
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 4
        const result_0=div_u((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 02 10 04
        // result 07 00 41 80 80 80 80 04
        // i32.const (-2147483648)
        // i32.const (2)
        // call 4
        const result_0=div_u((-2147483648),(2));
        // i32.const (1073741824)
        assert((1073741824) == result_0);
    }
    { // assert_return
        // expr   0D 00 41 F0 9F C0 FF 78 41 81 80 04 10 04
        // result 05 00 41 EF 9F 02
        // i32.const (-1880092688)
        // i32.const (65537)
        // call 4
        const result_0=div_u((-1880092688),(65537));
        // i32.const (36847)
        assert((36847) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 81 80 80 80 78 41 E8 07 10 04
        // result 06 00 41 9B 89 83 01
        // i32.const (-2147483647)
        // i32.const (1000)
        // call 4
        const result_0=div_u((-2147483647),(1000));
        // i32.const (2147483)
        assert((2147483) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 02 10 04
        // result 03 00 41 02
        // i32.const (5)
        // i32.const (2)
        // call 4
        const result_0=div_u((5),(2));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 02 10 04
        // result 07 00 41 FD FF FF FF 07
        // i32.const (-5)
        // i32.const (2)
        // call 4
        const result_0=div_u((-5),(2));
        // i32.const (2147483645)
        assert((2147483645) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 7E 10 04
        // result 03 00 41 00
        // i32.const (5)
        // i32.const (-2)
        // call 4
        const result_0=div_u((5),(-2));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 7E 10 04
        // result 03 00 41 00
        // i32.const (-5)
        // i32.const (-2)
        // call 4
        const result_0=div_u((-5),(-2));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 03 10 04
        // result 03 00 41 02
        // i32.const (7)
        // i32.const (3)
        // call 4
        const result_0=div_u((7),(3));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 0B 41 05 10 04
        // result 03 00 41 02
        // i32.const (11)
        // i32.const (5)
        // call 4
        const result_0=div_u((11),(5));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 11 41 07 10 04
        // result 03 00 41 02
        // i32.const (17)
        // i32.const (7)
        // call 4
        const result_0=div_u((17),(7));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_trap
        // expr   07 00 41 01 41 00 10 05
        // result 
        wasm.assert_trap((() {
                // i32.const (1)
                // i32.const (0)
                // call 5
                const result_0=rem_s((1),(0));
                return result_0;
            }
        )());
    }
    { // assert_trap
        // expr   07 00 41 00 41 00 10 05
        // result 
        wasm.assert_trap((() {
                // i32.const (0)
                // i32.const (0)
                // call 5
                const result_0=rem_s((0),(0));
                return result_0;
            }
        )());
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 7F 10 05
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-1)
        // call 5
        const result_0=rem_s((2147483647),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 05
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 5
        const result_0=rem_s((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 05
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 5
        const result_0=rem_s((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 05
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 5
        const result_0=rem_s((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 02 10 05
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2)
        // call 5
        const result_0=rem_s((-2147483648),(2));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 81 80 80 80 78 41 E8 07 10 05
        // result 04 00 41 F9 7A
        // i32.const (-2147483647)
        // i32.const (1000)
        // call 5
        const result_0=rem_s((-2147483647),(1000));
        // i32.const (-647)
        assert((-647) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 02 10 05
        // result 03 00 41 01
        // i32.const (5)
        // i32.const (2)
        // call 5
        const result_0=rem_s((5),(2));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 02 10 05
        // result 03 00 41 7F
        // i32.const (-5)
        // i32.const (2)
        // call 5
        const result_0=rem_s((-5),(2));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 7E 10 05
        // result 03 00 41 01
        // i32.const (5)
        // i32.const (-2)
        // call 5
        const result_0=rem_s((5),(-2));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 7E 10 05
        // result 03 00 41 7F
        // i32.const (-5)
        // i32.const (-2)
        // call 5
        const result_0=rem_s((-5),(-2));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 03 10 05
        // result 03 00 41 01
        // i32.const (7)
        // i32.const (3)
        // call 5
        const result_0=rem_s((7),(3));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 79 41 03 10 05
        // result 03 00 41 7F
        // i32.const (-7)
        // i32.const (3)
        // call 5
        const result_0=rem_s((-7),(3));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 7D 10 05
        // result 03 00 41 01
        // i32.const (7)
        // i32.const (-3)
        // call 5
        const result_0=rem_s((7),(-3));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 79 41 7D 10 05
        // result 03 00 41 7F
        // i32.const (-7)
        // i32.const (-3)
        // call 5
        const result_0=rem_s((-7),(-3));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 0B 41 05 10 05
        // result 03 00 41 01
        // i32.const (11)
        // i32.const (5)
        // call 5
        const result_0=rem_s((11),(5));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 11 41 07 10 05
        // result 03 00 41 03
        // i32.const (17)
        // i32.const (7)
        // call 5
        const result_0=rem_s((17),(7));
        // i32.const (3)
        assert((3) == result_0);
    }
    { // assert_trap
        // expr   07 00 41 01 41 00 10 06
        // result 
        wasm.assert_trap((() {
                // i32.const (1)
                // i32.const (0)
                // call 6
                const result_0=rem_u((1),(0));
                return result_0;
            }
        )());
    }
    { // assert_trap
        // expr   07 00 41 00 41 00 10 06
        // result 
        wasm.assert_trap((() {
                // i32.const (0)
                // i32.const (0)
                // call 6
                const result_0=rem_u((0),(0));
                return result_0;
            }
        )());
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 06
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 6
        const result_0=rem_u((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 06
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 6
        const result_0=rem_u((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 06
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 6
        const result_0=rem_u((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 06
        // result 07 00 41 80 80 80 80 78
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 6
        const result_0=rem_u((-2147483648),(-1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 02 10 06
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2)
        // call 6
        const result_0=rem_u((-2147483648),(2));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0D 00 41 F0 9F C0 FF 78 41 81 80 04 10 06
        // result 05 00 41 81 80 02
        // i32.const (-1880092688)
        // i32.const (65537)
        // call 6
        const result_0=rem_u((-1880092688),(65537));
        // i32.const (32769)
        assert((32769) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 81 80 80 80 78 41 E8 07 10 06
        // result 04 00 41 89 05
        // i32.const (-2147483647)
        // i32.const (1000)
        // call 6
        const result_0=rem_u((-2147483647),(1000));
        // i32.const (649)
        assert((649) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 02 10 06
        // result 03 00 41 01
        // i32.const (5)
        // i32.const (2)
        // call 6
        const result_0=rem_u((5),(2));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 02 10 06
        // result 03 00 41 01
        // i32.const (-5)
        // i32.const (2)
        // call 6
        const result_0=rem_u((-5),(2));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 05 41 7E 10 06
        // result 03 00 41 05
        // i32.const (5)
        // i32.const (-2)
        // call 6
        const result_0=rem_u((5),(-2));
        // i32.const (5)
        assert((5) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7B 41 7E 10 06
        // result 03 00 41 7B
        // i32.const (-5)
        // i32.const (-2)
        // call 6
        const result_0=rem_u((-5),(-2));
        // i32.const (-5)
        assert((-5) == result_0);
    }
    { // assert_return
        // expr   07 00 41 07 41 03 10 06
        // result 03 00 41 01
        // i32.const (7)
        // i32.const (3)
        // call 6
        const result_0=rem_u((7),(3));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 0B 41 05 10 06
        // result 03 00 41 01
        // i32.const (11)
        // i32.const (5)
        // call 6
        const result_0=rem_u((11),(5));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 11 41 07 10 06
        // result 03 00 41 03
        // i32.const (17)
        // i32.const (7)
        // call 6
        const result_0=rem_u((17),(7));
        // i32.const (3)
        assert((3) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 07
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 7
        const result_0=and((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 07
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 7
        const result_0=and((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 07
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 7
        const result_0=and((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 07
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 7
        const result_0=and((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 07
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 7
        const result_0=and((2147483647),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 7F 10 07
        // result 07 00 41 FF FF FF FF 07
        // i32.const (2147483647)
        // i32.const (-1)
        // call 7
        const result_0=and((2147483647),(-1));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 FF FF C3 87 7F 41 F0 61 10 07
        // result 07 00 41 F0 E1 C3 87 7F
        // i32.const (-252641281)
        // i32.const (-3856)
        // call 7
        const result_0=and((-252641281),(-3856));
        // i32.const (-252645136)
        assert((-252645136) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 07
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (-1)
        // call 7
        const result_0=and((-1),(-1));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 08
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 8
        const result_0=or((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 08
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 8
        const result_0=or((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 08
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 8
        const result_0=or((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 08
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 8
        const result_0=or((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 08
        // result 03 00 41 7F
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 8
        const result_0=or((2147483647),(-2147483648));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 08
        // result 07 00 41 80 80 80 80 78
        // i32.const (-2147483648)
        // i32.const (0)
        // call 8
        const result_0=or((-2147483648),(0));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 FF FF C3 87 7F 41 F0 61 10 08
        // result 03 00 41 7F
        // i32.const (-252641281)
        // i32.const (-3856)
        // call 8
        const result_0=or((-252641281),(-3856));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 08
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (-1)
        // call 8
        const result_0=or((-1),(-1));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 09
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 9
        const result_0=xor((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 09
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 9
        const result_0=xor((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 09
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 9
        const result_0=xor((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 09
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 9
        const result_0=xor((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 09
        // result 03 00 41 7F
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 9
        const result_0=xor((2147483647),(-2147483648));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 09
        // result 07 00 41 80 80 80 80 78
        // i32.const (-2147483648)
        // i32.const (0)
        // call 9
        const result_0=xor((-2147483648),(0));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 09
        // result 07 00 41 FF FF FF FF 07
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 9
        const result_0=xor((-1),(-2147483648));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 FF FF FF FF 07 10 09
        // result 07 00 41 80 80 80 80 78
        // i32.const (-1)
        // i32.const (2147483647)
        // call 9
        const result_0=xor((-1),(2147483647));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0C 00 41 FF FF C3 87 7F 41 F0 61 10 09
        // result 07 00 41 8F 9E BC F8 00
        // i32.const (-252641281)
        // i32.const (-3856)
        // call 9
        const result_0=xor((-252641281),(-3856));
        // i32.const (252645135)
        assert((252645135) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 09
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 9
        const result_0=xor((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 0A
        // result 03 00 41 02
        // i32.const (1)
        // i32.const (1)
        // call 10
        const result_0=shl((1),(1));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 0A
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 10
        const result_0=shl((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 01 10 0A
        // result 03 00 41 7E
        // i32.const (2147483647)
        // i32.const (1)
        // call 10
        const result_0=shl((2147483647),(1));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 0A
        // result 03 00 41 7E
        // i32.const (-1)
        // i32.const (1)
        // call 10
        const result_0=shl((-1),(1));
        // i32.const (-2)
        assert((-2) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 01 10 0A
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (1)
        // call 10
        const result_0=shl((-2147483648),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 04 41 01 10 0A
        // result 07 00 41 80 80 80 80 78
        // i32.const (1073741824)
        // i32.const (1)
        // call 10
        const result_0=shl((1073741824),(1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 1F 10 0A
        // result 07 00 41 80 80 80 80 78
        // i32.const (1)
        // i32.const (31)
        // call 10
        const result_0=shl((1),(31));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 20 10 0A
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (32)
        // call 10
        const result_0=shl((1),(32));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 21 10 0A
        // result 03 00 41 02
        // i32.const (1)
        // i32.const (33)
        // call 10
        const result_0=shl((1),(33));
        // i32.const (2)
        assert((2) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 7F 10 0A
        // result 07 00 41 80 80 80 80 78
        // i32.const (1)
        // i32.const (-1)
        // call 10
        const result_0=shl((1),(-1));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 01 41 FF FF FF FF 07 10 0A
        // result 07 00 41 80 80 80 80 78
        // i32.const (1)
        // i32.const (2147483647)
        // call 10
        const result_0=shl((1),(2147483647));
        // i32.const (-2147483648)
        assert((-2147483648) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 0B
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 11
        const result_0=shr_s((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 0B
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 11
        const result_0=shr_s((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (1)
        // call 11
        const result_0=shr_s((-1),(1));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 01 10 0B
        // result 07 00 41 FF FF FF FF 03
        // i32.const (2147483647)
        // i32.const (1)
        // call 11
        const result_0=shr_s((2147483647),(1));
        // i32.const (1073741823)
        assert((1073741823) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 01 10 0B
        // result 07 00 41 80 80 80 80 7C
        // i32.const (-2147483648)
        // i32.const (1)
        // call 11
        const result_0=shr_s((-2147483648),(1));
        // i32.const (-1073741824)
        assert((-1073741824) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 04 41 01 10 0B
        // result 07 00 41 80 80 80 80 02
        // i32.const (1073741824)
        // i32.const (1)
        // call 11
        const result_0=shr_s((1073741824),(1));
        // i32.const (536870912)
        assert((536870912) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 20 10 0B
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (32)
        // call 11
        const result_0=shr_s((1),(32));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 21 10 0B
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (33)
        // call 11
        const result_0=shr_s((1),(33));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 7F 10 0B
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (-1)
        // call 11
        const result_0=shr_s((1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 01 41 FF FF FF FF 07 10 0B
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (2147483647)
        // call 11
        const result_0=shr_s((1),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 01 41 80 80 80 80 78 10 0B
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (-2147483648)
        // call 11
        const result_0=shr_s((1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 1F 10 0B
        // result 03 00 41 7F
        // i32.const (-2147483648)
        // i32.const (31)
        // call 11
        const result_0=shr_s((-2147483648),(31));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 20 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (32)
        // call 11
        const result_0=shr_s((-1),(32));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 21 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (33)
        // call 11
        const result_0=shr_s((-1),(33));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (-1)
        // call 11
        const result_0=shr_s((-1),(-1));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 FF FF FF FF 07 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (2147483647)
        // call 11
        const result_0=shr_s((-1),(2147483647));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 0B
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 11
        const result_0=shr_s((-1),(-2147483648));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 0C
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 12
        const result_0=shr_u((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 0C
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 12
        const result_0=shr_u((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 0C
        // result 07 00 41 FF FF FF FF 07
        // i32.const (-1)
        // i32.const (1)
        // call 12
        const result_0=shr_u((-1),(1));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 FF FF FF FF 07 41 01 10 0C
        // result 07 00 41 FF FF FF FF 03
        // i32.const (2147483647)
        // i32.const (1)
        // call 12
        const result_0=shr_u((2147483647),(1));
        // i32.const (1073741823)
        assert((1073741823) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 01 10 0C
        // result 07 00 41 80 80 80 80 04
        // i32.const (-2147483648)
        // i32.const (1)
        // call 12
        const result_0=shr_u((-2147483648),(1));
        // i32.const (1073741824)
        assert((1073741824) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 04 41 01 10 0C
        // result 07 00 41 80 80 80 80 02
        // i32.const (1073741824)
        // i32.const (1)
        // call 12
        const result_0=shr_u((1073741824),(1));
        // i32.const (536870912)
        assert((536870912) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 20 10 0C
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (32)
        // call 12
        const result_0=shr_u((1),(32));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 21 10 0C
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (33)
        // call 12
        const result_0=shr_u((1),(33));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 7F 10 0C
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (-1)
        // call 12
        const result_0=shr_u((1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 01 41 FF FF FF FF 07 10 0C
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (2147483647)
        // call 12
        const result_0=shr_u((1),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 01 41 80 80 80 80 78 10 0C
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (-2147483648)
        // call 12
        const result_0=shr_u((1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 1F 10 0C
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (31)
        // call 12
        const result_0=shr_u((-2147483648),(31));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 20 10 0C
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (32)
        // call 12
        const result_0=shr_u((-1),(32));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 21 10 0C
        // result 07 00 41 FF FF FF FF 07
        // i32.const (-1)
        // i32.const (33)
        // call 12
        const result_0=shr_u((-1),(33));
        // i32.const (2147483647)
        assert((2147483647) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 0C
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 12
        const result_0=shr_u((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 FF FF FF FF 07 10 0C
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (2147483647)
        // call 12
        const result_0=shr_u((-1),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 0C
        // result 03 00 41 7F
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 12
        const result_0=shr_u((-1),(-2147483648));
        // i32.const (-1)
        assert((-1) == result_0);
    }
    { // assert_return
        // expr   05 00 41 7F 10 0D
        // result 03 00 41 00
        // i32.const (-1)
        // call 13
        const result_0=clz((-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   05 00 41 00 10 0D
        // result 03 00 41 20
        // i32.const (0)
        // call 13
        const result_0=clz((0));
        // i32.const (32)
        assert((32) == result_0);
    }
    { // assert_return
        // expr   07 00 41 80 80 02 10 0D
        // result 03 00 41 10
        // i32.const (32768)
        // call 13
        const result_0=clz((32768));
        // i32.const (16)
        assert((16) == result_0);
    }
    { // assert_return
        // expr   06 00 41 FF 01 10 0D
        // result 03 00 41 18
        // i32.const (255)
        // call 13
        const result_0=clz((255));
        // i32.const (24)
        assert((24) == result_0);
    }
    { // assert_return
        // expr   09 00 41 80 80 80 80 78 10 0D
        // result 03 00 41 00
        // i32.const (-2147483648)
        // call 13
        const result_0=clz((-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   05 00 41 01 10 0D
        // result 03 00 41 1F
        // i32.const (1)
        // call 13
        const result_0=clz((1));
        // i32.const (31)
        assert((31) == result_0);
    }
    { // assert_return
        // expr   05 00 41 02 10 0D
        // result 03 00 41 1E
        // i32.const (2)
        // call 13
        const result_0=clz((2));
        // i32.const (30)
        assert((30) == result_0);
    }
    { // assert_return
        // expr   05 00 41 7F 10 0E
        // result 03 00 41 00
        // i32.const (-1)
        // call 14
        const result_0=ctz((-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   05 00 41 00 10 0E
        // result 03 00 41 20
        // i32.const (0)
        // call 14
        const result_0=ctz((0));
        // i32.const (32)
        assert((32) == result_0);
    }
    { // assert_return
        // expr   07 00 41 80 80 02 10 0E
        // result 03 00 41 0F
        // i32.const (32768)
        // call 14
        const result_0=ctz((32768));
        // i32.const (15)
        assert((15) == result_0);
    }
    { // assert_return
        // expr   07 00 41 80 80 04 10 0E
        // result 03 00 41 10
        // i32.const (65536)
        // call 14
        const result_0=ctz((65536));
        // i32.const (16)
        assert((16) == result_0);
    }
    { // assert_return
        // expr   09 00 41 80 80 80 80 78 10 0E
        // result 03 00 41 1F
        // i32.const (-2147483648)
        // call 14
        const result_0=ctz((-2147483648));
        // i32.const (31)
        assert((31) == result_0);
    }
    { // assert_return
        // expr   05 00 41 7F 10 0F
        // result 03 00 41 20
        // i32.const (-1)
        // call 15
        const result_0=popcnt((-1));
        // i32.const (32)
        assert((32) == result_0);
    }
    { // assert_return
        // expr   05 00 41 00 10 0F
        // result 03 00 41 00
        // i32.const (0)
        // call 15
        const result_0=popcnt((0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 80 80 02 10 0F
        // result 03 00 41 01
        // i32.const (32768)
        // call 15
        const result_0=popcnt((32768));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 10
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (0)
        // call 16
        const result_0=eq((0),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 10
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 16
        const result_0=eq((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 10
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 16
        const result_0=eq((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 10
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 16
        const result_0=eq((-2147483648),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 10
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 16
        const result_0=eq((2147483647),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 10
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 16
        const result_0=eq((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 10
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 16
        const result_0=eq((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 10
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 16
        const result_0=eq((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 10
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 16
        const result_0=eq((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 10
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 16
        const result_0=eq((-2147483648),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 11
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 17
        const result_0=ne((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 11
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 17
        const result_0=ne((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 11
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (1)
        // call 17
        const result_0=ne((-1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 11
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 17
        const result_0=ne((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 11
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 17
        const result_0=ne((2147483647),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 11
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 17
        const result_0=ne((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 11
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 17
        const result_0=ne((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 11
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (0)
        // call 17
        const result_0=ne((-2147483648),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 11
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 17
        const result_0=ne((-2147483648),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 11
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 17
        const result_0=ne((-2147483648),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 12
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 18
        const result_0=lt_s((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 12
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 18
        const result_0=lt_s((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 12
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (1)
        // call 18
        const result_0=lt_s((-1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 12
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 18
        const result_0=lt_s((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 12
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 18
        const result_0=lt_s((2147483647),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 12
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 18
        const result_0=lt_s((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 12
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 18
        const result_0=lt_s((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 12
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 18
        const result_0=lt_s((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 12
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (0)
        // call 18
        const result_0=lt_s((-2147483648),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 12
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (-2147483648)
        // call 18
        const result_0=lt_s((0),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 12
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 18
        const result_0=lt_s((-2147483648),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 12
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 18
        const result_0=lt_s((-1),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 12
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 18
        const result_0=lt_s((-2147483648),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 12
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 18
        const result_0=lt_s((2147483647),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 13
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 19
        const result_0=lt_u((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 13
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 19
        const result_0=lt_u((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 13
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 19
        const result_0=lt_u((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 13
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 19
        const result_0=lt_u((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 13
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 19
        const result_0=lt_u((2147483647),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 13
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 19
        const result_0=lt_u((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 13
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 19
        const result_0=lt_u((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 13
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 19
        const result_0=lt_u((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 13
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 19
        const result_0=lt_u((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 13
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (-2147483648)
        // call 19
        const result_0=lt_u((0),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 13
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 19
        const result_0=lt_u((-2147483648),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 13
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 19
        const result_0=lt_u((-1),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 13
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 19
        const result_0=lt_u((-2147483648),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 13
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 19
        const result_0=lt_u((2147483647),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 14
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (0)
        // call 20
        const result_0=le_s((0),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 14
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 20
        const result_0=le_s((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 14
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (1)
        // call 20
        const result_0=le_s((-1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 14
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 20
        const result_0=le_s((-2147483648),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 14
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 20
        const result_0=le_s((2147483647),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 14
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 20
        const result_0=le_s((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 14
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 20
        const result_0=le_s((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 14
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 20
        const result_0=le_s((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 14
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (0)
        // call 20
        const result_0=le_s((-2147483648),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 14
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (-2147483648)
        // call 20
        const result_0=le_s((0),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 14
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 20
        const result_0=le_s((-2147483648),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 14
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 20
        const result_0=le_s((-1),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 14
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 20
        const result_0=le_s((-2147483648),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 14
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 20
        const result_0=le_s((2147483647),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 15
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (0)
        // call 21
        const result_0=le_u((0),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 15
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 21
        const result_0=le_u((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 15
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 21
        const result_0=le_u((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 15
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 21
        const result_0=le_u((-2147483648),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 15
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 21
        const result_0=le_u((2147483647),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 15
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 21
        const result_0=le_u((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 15
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (0)
        // call 21
        const result_0=le_u((1),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 15
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (1)
        // call 21
        const result_0=le_u((0),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 15
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 21
        const result_0=le_u((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 15
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (-2147483648)
        // call 21
        const result_0=le_u((0),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 15
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 21
        const result_0=le_u((-2147483648),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 15
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 21
        const result_0=le_u((-1),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 15
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 21
        const result_0=le_u((-2147483648),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 15
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 21
        const result_0=le_u((2147483647),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 16
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 22
        const result_0=gt_s((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 16
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 22
        const result_0=gt_s((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 16
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 22
        const result_0=gt_s((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 16
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 22
        const result_0=gt_s((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 16
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 22
        const result_0=gt_s((2147483647),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 16
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 22
        const result_0=gt_s((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 16
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 22
        const result_0=gt_s((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 16
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 22
        const result_0=gt_s((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 16
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 22
        const result_0=gt_s((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 16
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (-2147483648)
        // call 22
        const result_0=gt_s((0),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 16
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 22
        const result_0=gt_s((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 16
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 22
        const result_0=gt_s((-1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 16
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 22
        const result_0=gt_s((-2147483648),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 16
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 22
        const result_0=gt_s((2147483647),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 17
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (0)
        // call 23
        const result_0=gt_u((0),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 17
        // result 03 00 41 00
        // i32.const (1)
        // i32.const (1)
        // call 23
        const result_0=gt_u((1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 17
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (1)
        // call 23
        const result_0=gt_u((-1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 17
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 23
        const result_0=gt_u((-2147483648),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 17
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 23
        const result_0=gt_u((2147483647),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 17
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (-1)
        // call 23
        const result_0=gt_u((-1),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 17
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 23
        const result_0=gt_u((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 17
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 23
        const result_0=gt_u((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 17
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (0)
        // call 23
        const result_0=gt_u((-2147483648),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 17
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (-2147483648)
        // call 23
        const result_0=gt_u((0),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 17
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 23
        const result_0=gt_u((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 17
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 23
        const result_0=gt_u((-1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 17
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 23
        const result_0=gt_u((-2147483648),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 17
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 23
        const result_0=gt_u((2147483647),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 18
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (0)
        // call 24
        const result_0=ge_s((0),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 18
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 24
        const result_0=ge_s((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 18
        // result 03 00 41 00
        // i32.const (-1)
        // i32.const (1)
        // call 24
        const result_0=ge_s((-1),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 18
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 24
        const result_0=ge_s((-2147483648),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 18
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 24
        const result_0=ge_s((2147483647),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 18
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 24
        const result_0=ge_s((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 18
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 24
        const result_0=ge_s((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 18
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 24
        const result_0=ge_s((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 18
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (0)
        // call 24
        const result_0=ge_s((-2147483648),(0));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 18
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (-2147483648)
        // call 24
        const result_0=ge_s((0),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 18
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 24
        const result_0=ge_s((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 18
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 24
        const result_0=ge_s((-1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 18
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 24
        const result_0=ge_s((-2147483648),(2147483647));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 18
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 24
        const result_0=ge_s((2147483647),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 00 10 19
        // result 03 00 41 01
        // i32.const (0)
        // i32.const (0)
        // call 25
        const result_0=ge_u((0),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 01 10 19
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (1)
        // call 25
        const result_0=ge_u((1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 01 10 19
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (1)
        // call 25
        const result_0=ge_u((-1),(1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 80 80 80 80 78 10 19
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (-2147483648)
        // call 25
        const result_0=ge_u((-2147483648),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 FF FF FF FF 07 10 19
        // result 03 00 41 01
        // i32.const (2147483647)
        // i32.const (2147483647)
        // call 25
        const result_0=ge_u((2147483647),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 7F 41 7F 10 19
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-1)
        // call 25
        const result_0=ge_u((-1),(-1));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 01 41 00 10 19
        // result 03 00 41 01
        // i32.const (1)
        // i32.const (0)
        // call 25
        const result_0=ge_u((1),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   07 00 41 00 41 01 10 19
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (1)
        // call 25
        const result_0=ge_u((0),(1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 00 10 19
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (0)
        // call 25
        const result_0=ge_u((-2147483648),(0));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 00 41 80 80 80 80 78 10 19
        // result 03 00 41 00
        // i32.const (0)
        // i32.const (-2147483648)
        // call 25
        const result_0=ge_u((0),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 80 80 80 80 78 41 7F 10 19
        // result 03 00 41 00
        // i32.const (-2147483648)
        // i32.const (-1)
        // call 25
        const result_0=ge_u((-2147483648),(-1));
        // i32.const (0)
        assert((0) == result_0);
    }
    { // assert_return
        // expr   0B 00 41 7F 41 80 80 80 80 78 10 19
        // result 03 00 41 01
        // i32.const (-1)
        // i32.const (-2147483648)
        // call 25
        const result_0=ge_u((-1),(-2147483648));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 80 80 80 80 78 41 FF FF FF FF 07 10 19
        // result 03 00 41 01
        // i32.const (-2147483648)
        // i32.const (2147483647)
        // call 25
        const result_0=ge_u((-2147483648),(2147483647));
        // i32.const (1)
        assert((1) == result_0);
    }
    { // assert_return
        // expr   0F 00 41 FF FF FF FF 07 41 80 80 80 80 78 10 19
        // result 03 00 41 00
        // i32.const (2147483647)
        // i32.const (-2147483648)
        // call 25
        const result_0=ge_u((2147483647),(-2147483648));
        // i32.const (0)
        assert((0) == result_0);
    }
}
// end
